<?php 
/**
* Extension of Codeigniter's {@link http://codeigniter.com/user_guide/helpers/array_helper.html array_helper}.
*
* @package direct-as-a-service
* @subpackage helpers
*/
load_libraries('Error_helper', 'Validator');

/**
* Returns the first element in an array.
* Operates like CI's {@link http://codeigniter.com/user_guide/helpers/array_helper.html element()} function, but doesn't require that you know what the key is.
*
* @uses element_number()
*
* @param array 
* @param mixed Return this if the array is empty.  (Optional, defaults to false).
* @return mixed 
*/
function first_element($array, $default = false){
	if(!validates_as('array', $array)) return should_be('an array', $array);		
	return element_number(1, $array, $default);
}

/**
* Returns the last element in an array.
* Operates like CI's {@link element http://codeigniter.com/user_guide/helpers/array_helper.html} function, but doesn't require that you know what the key is.
*
* @uses element_number()
*
* @param array 
* @param mixed Return this if the array is empty.  (Optional, defaults to false).
* @return mixed 
*/
function last_element($array, $default = false){
	if(!validates_as('array', $array)) return should_be('an array', $array);		
	if(!empty($array) && is_array($array)){
		end($array);
		return current($array);
	}
	return $default;
}

/**
* Returns the nth element in an array.
* Like {@link first_element()} & {@link last_element()}, but for any item in the array.
* @param int Which element to return.  (1 for the first element, 2 for for the second, etc.)
* @param array 
* @param mixed Return this if the array is empty.  (Optional, defaults to false).
* @return mixed
*/
function element_number($number, $array, $default = false){
	if(!validates_as('nonzero_unsigned_integer', $number)) return should_be('a nonzero unsigned integer', $number);
	if(!validates_as('array', $array)) return should_be('an array', $array);	
	
	if(is_array($array) && $number <= count($array) ){
		reset($array);
		for($i=1; $i<$number; $i++)
			next($array);
		return current($array);
	}
	return $default;
}


/**
*  Reduces a multidimensional array to a one-dimensional array.  
*  e.g., array(1, 2, array(a, b, c), 3, array( array(d, e), 4))) becomes array(1, 2, a, b, c, 3, d, e, 4)
*  Note that keys will not be preserved, due to the possibility of collisions.
*  @param mixed $array_to_be_flattened  The multidimensional array. (On subsequent recursive calls, this param won't be an array, but it should be when you call it initially).
*  @param array $destination_array (Intended just to be used internally by the function) Container for array entries - at the end, this will be the "flat" array.
*  @return array
*/
function flatten_array($array_to_be_flattened, $destination_array = array()){
	//note to self - don't validate array_to_be_flattened, after a recursive iteration or two it won't be an array			
	if(!is_array($destination_array)){
		trigger_error('Second parameter is not an array - ignoring and replacing with an empty array', E_USER_NOTICE);
		$destination_array = array();
	}
	
	if(is_array($array_to_be_flattened)){
		foreach($array_to_be_flattened as $array_item){
			$destination_array = flatten_array($array_item, $destination_array);
		}
	}
	else
		$destination_array[] = $array_to_be_flattened; //at this point, it's not an array -- it's an array entry appropriate for the "flat" array
	return $destination_array;
}

/**
* Like the php-native implode, but will first glue together the key and the value before gluing together the array.
* @param array $array
* @param string $key_value_glue (Optional) The 'glue' used to concat the key and the value; defaults to '='
* @param string $array_item_glue (Optional) The 'glue' used to concat the items of the array (normal php implode glue).  Defaults to ' '..
* @return string
*/
function key_value_implode($array, $key_value_glue = '=', $array_item_glue = ' '){
	if(!validates_as('array', $array)) return should_be('an array', $array);
	foreach($array as $key => $value){
		$array[$key] = $key.$key_value_glue.$value;
	}
	return implode($array_item_glue, $array);
}

function implode_nonempty($glue, $array){
	if(!validates_as('string', $glue)) return should_be('string', $glue);
	if(!validates_as('array', $array)) return should_be('array', $array);
	foreach($array as $key => $value){
		if(empty($value) && $value !== 0)
			unset($array[$key]);
	}
	return implode($glue, $array);
}

function key_value_implode_nonempty($array, $key_value_glue = '=', $array_item_glue = ' '){
	if(!validates_as('array', $array)) return should_be('an array', $array);
	$nonempty_items = array();	
	foreach($array as $key => $value){
		if(!empty($value) || $value === 0)
			$nonempty_items[$key] = $key.$key_value_glue.$value;
	}
	return implode($array_item_glue, $nonempty_items);
}

/**
* Accurately returns the first key in the array, even if the array doesn't use numerical keys.
* This comes in handy when you need to make sure that you don't change the internal pointer of the array in the place where you're working (e.g., within a foreach loop.)
* @param array $array The array that you want to get the first key from 
* @return mixed The first key in the array
*/
function array_first_key($array){
	if(!validates_as('array', $array)) return should_be('an array', $array);		
	reset($array);
	return key($array);
}

/**
* Accurately returns the last key in the array, even if the array doesn't use numerical keys.
* This comes in handy when you need to make sure that you don't change the internal pointer of the array in the place where you're working (e.g., within a foreach loop.)
* @param array $array The array that you want to get the last key from 
* @return mixed The last key in the array
*/
function array_last_key($array){
	if(!validates_as('array', $array)) return should_be('an array', $array);		
	end($array);
	return key($array);
}

#TODO -- DOCUMENT
//Create an array of the values of the property
function collect($property_or_index, $array_of_objects_or_arrays){
	if(!is_scalar($property_or_index)) return should_be('array index or an object property', $property_or_index);
	if(!is_array($array_of_objects_or_arrays)) return should_be('array', $array_of_objects_or_arrays);
	
	$collection = array();
	foreach($array_of_objects_or_arrays as $key => $array_or_object){
		if(is_array($array_or_object)){
			if(!array_key_exists($property_or_index, $array_or_object))
				return should_be('an index for each array in the collection', $property_or_index);
			$collection[$key] = $array_or_object[$property_or_index];
		}
		elseif(is_object($array_or_object)){
			$collection[$key] = $array_or_object->$property_or_index;
		}
		else{
			return should_be('array or object', $array_or_object);
		}
	}
	
	return $collection;
}

/* End of file MY_string_helper.php */